function findBinaryWord( word ) {
  var l = word.length;
  // Don't search if there's nothing to look through
  if ( !bd[l] ) {
    return false;
  }
  // Get the number of words in the dictionary bin
  var words = bd[l].length / l,
    // The low point from where we're starting the binary search
    low = 0,
    // The max high point
    high = words - 1,
    // And the precise middle of the search
    mid = Math.floor( words / 2 );
  // We continue to look until we reach a final word
  while ( high >= low ) {
    // Grab the word at our current position
    var found = bd[l].substr( l * mid, l );
    // If we've found the word, stop now
    if ( word === found ) {
      return true;
    }
    // Otherwise, compare
    // If we're too high, move lower
    if ( word < found ) {
      high = mid - 1;
    // If we're too low, go higher
    } else {
      low = mid + 1;
    }
    // And find the new search point
    mid = Math.floor( (low + high) / 2 );
  }
  // Nothing was found
  return false;
}

var start = new Date();
var bdjson = readFile("binarydict.json");
var endload = new Date();
var startev = new Date();
var bd = eval(bdjson)
var endev = new Date();
var times = [];
["PIES", "MYSTICAL", "MYSTICALA", "OF", "COUNTER", "BRINT"].forEach(function(word) {
    var begin = new Date();
    var found = findBinaryWord(word);
    var end = new Date();
    print(word + ":" + (found ? "exists" : "does not exist"));
    times.push(end.getTime() - begin.getTime());
});
print("Time to load file: " + (endload.getTime() - start.getTime()));
print("Time to eval file: " + (endev.getTime() - startev.getTime()));

var total = 0;
for (var i=0; i<times.length; i++) total += times[i];
var avg = total / times.length;
print("Average search time: " + avg);
