# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2013 Canonical Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

from ubuntuuitoolkit import emulators as toolkit_emulators


class MainView(toolkit_emulators.MainView):

    def get_main_score_label(self):
        item = self.select_single('QQuickItem', objectName='mainscore')
        return item.select_single('Label')

    def get_letter_tiles(self):
        item = self.select_many('QQuickRectangle', objectName='gametilebox')
        return item

    def get_word_label(self):
        item = self.select_single('Label', objectName='accumulate')
        return item

    def get_help_button(self):
        item = self.select_single('QQuickRectangle',
                                  objectName='introhelpbutton')
        return item

    def get_help_popover(self):
        # checking the popup seems to fail
        # -- https://bugs.launchpad.net/autopilot/+bug/1195141?
        # we can't get the popup by objectname for ??
        # this works OK because at the moment, there is only one popup
        #  -- needs fixed
        # item = self.select_single('Label',
        #                           objectname='helpsheetpopoverlabel')
        # item = self.select_single('QQuickRectangle',
        #                          objectname='helpsheetpopoverbox')
        # item = self.select_single('Popover', objectname='helpsheetpopover')

        item = self.wait_select_single('Popover')
        return item

    def get_many_popover(self):
        """get a list of open popovers"""
        return self.select_many('Popover')
