import QtQuick 2.4
import U1db 1.0 as U1db

/* New interface for options.
 * Currently it is just facade on U1DB.
 */
Item {

    property int fontSize
    property bool useDarkTheme
    property bool useListMode
    property bool useGoogleSearch

    Component.onCompleted: {
        fontSize = getFontSize()
        useDarkTheme = getUseDarkTheme()
        useListMode = getUseListMode()
        useGoogleSearch = getUseGoogleSearch()
    }

    onFontSizeChanged: setFontSize(fontSize)
    onUseDarkThemeChanged: setUseDarkTheme(useDarkTheme)
    onUseListModeChanged: setUseListMode(useListMode)
    onUseGoogleSearchChanged: setUseGoogleSearch(useGoogleSearch)

    function getFontSize() {
        return settingsDocument.contents.fontSize
    }

    function setFontSize(value) {
        var cont = settingsDocument.contents
        cont.fontSize = value
        settingsDocument.contents = cont
    }

    function getUseDarkTheme() {
        return settingsDocument.contents.useDarkTheme
    }

    function setUseDarkTheme(value) {
        var cont = settingsDocument.contents
        cont.useDarkTheme = value
        settingsDocument.contents = cont
    }

    function getUseListMode() {
        return settingsDocument.contents.useListMode
    }

    function setUseListMode(value) {
        var cont = settingsDocument.contents
        cont.useListMode = value
        settingsDocument.contents = cont
    }

    function dbVersion() {
        return settingsDocument.contents.dbVersion
    }

    function setDbVersion(value) {
        var cont = settingsDocument.contents
        cont.dbVersion = value
        settingsDocument.contents = cont
    }

    function dbLastUpdate() {
        return settingsDocument.contents.dbLastUpdate
    }

    function getUseGoogleSearch() {
        return settingsDocument.contents.useGoogleSearch
    }

    function setUseGoogleSearch(value) {
        var cont = settingsDocument.contents
        cont.useGoogleSearch = value
        settingsDocument.contents = cont
    }

    U1db.Database {
        id: settingsDataBase
        path: "ShortsOptions"
    }

    U1db.Document {
        id: settingsDocument
        database: settingsDataBase
        docId: 'settingsDocument'
        create: true
        defaults: { "useDarkTheme" : false, "fontSize" : 1,
                    "useListMode" : false, "dbVersion" : 1.2,
                    "useGoogleSearch" : true
        }
    }
} // Item
