/*
 * Copyright (C) 2013, 2014
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.4
import Ubuntu.Components 1.3
//import Ubuntu.Components.ListItems 1.3 as ListItem
//import Ubuntu.Components.Popups 1.3

import QtQuick.XmlListModel 2.0

import "../utils/databasemodule_v2.js" as DB
//import "../."

Item {
    id: opmlParser

    property string opmlPath: ""

    signal parseFinished(var opml)

    XmlListModel {
        id: modelOpml
        property string subTitle

        property var opmlObj
        property int currentRootsIndex: 0
        property int allRootsCount: 0

        function getAllRootObj() {
            var rootObjs = new Array
            // push all root objects to array
            for (var i=0; i<modelOpml.count; i++) {
                rootObjs.push(
                            //modelOpml.get(i)
                            {
                                "text": modelOpml.get(i).text
                                ,"title": modelOpml.get(i).title
                                ,"xmlUrl": modelOpml.get(i).xmlUrl
                                ,"htmlUrl": modelOpml.get(i).htmlUrl
                                ,"isSelected": false
                            }
                            )
            }
            opmlObj = rootObjs
            // set first subTitle
            subTitle = rootObjs[currentRootsIndex].text
        }

        function getChildObjsFromOneRoot() {
            var rootObjs = opmlObj
            var array = new Array
            for (var i=0; i<modelOpml.count; i++) {
//                rootObjs[currentRootsIndex].children.push(
                if (modelOpml.get(i).xmlUrl != "") {
                    array.push(
                                {
                                    "text": modelOpml.get(i).text
                                    ,"title": modelOpml.get(i).title
                                    ,"xmlUrl": modelOpml.get(i).xmlUrl
                                    ,"htmlUrl": modelOpml.get(i).htmlUrl
                                    ,"isSelected": false
                                }
                                )
                }
            }
            rootObjs[currentRootsIndex].children = array
            opmlObj = rootObjs
            // if not end of the roots, set next subTitle
            if (currentRootsIndex < (allRootsCount - 1)) {
                currentRootsIndex ++
                subTitle = rootObjs[currentRootsIndex].text
            }
            // else send finish signal
            else {
                console.log("children objs: ", JSON.stringify(opmlObj))
                parseFinished(opmlObj)
            }
        }

        onStatusChanged: {
            console.log("model status:", status)
            if (status == XmlListModel.Ready) {
                if (!subTitle) {
                    allRootsCount = count
                    // get all root object
                    getAllRootObj()
                }
                else {
                    // load children object one by one
//                    console.log("children objs: ", JSON.stringify(opmlObj))
//                    console.log("model count: ", count)
                    getChildObjsFromOneRoot()
                }
            }
            else if (status == XmlListModel.Error) {
                console.log("XmlListModel.Error: ", errorString())
            }
        }

        query: subTitle ? "/opml/body/outline[@text='" + subTitle + "']/outline": "/opml/body/outline"
        //        query: "/opml/body/outline"
        source:   opmlPath

        XmlRole { name: 'text'; query: '@text/string()' }
        XmlRole { name: 'title'; query: '@title/string()' }
        XmlRole { name: 'type'; query: '@type/string()' }
        XmlRole { name: 'xmlUrl'; query: '@xmlUrl/string()' }
        XmlRole { name: 'htmlUrl'; query: '@htmlUrl/string()' }
    }
}
