import QtQuick 2.4
import Ubuntu.Components 1.3
import Ubuntu.Components.ListItems 1.3 as ListItem
import Ubuntu.Components.Popups 1.3
import "../components"

Page {
    id: pageSettings
    title: i18n.tr("Settings")
    flickable: null

    property bool preventSave: false

    Component.onCompleted: updateInfoFromOptions()

    function updateInfoFromOptions() {
        preventSave = true

        swUseGfa.checked = optionsKeeper.useGoogleSearch

        preventSave = false
    }

    Column {
        anchors {
            top: parent.top; topMargin: units.gu(1.5)
            left: parent.left; leftMargin: units.gu(0)
            right: parent.right; rightMargin: units.gu(0)
        }
        height: childrenRect.height
//        spacing: units.gu(0.8)

        /////////////////////////////////////////////////////////////////////   Google RSS engine switch    start here
        Label {
            anchors { left: parent.left; right: parent.right; margins: units.gu(2) }
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
            text: i18n.tr("For those who living in some special regions cannot access Google, the switch below can disable Google RSS engine, Shorts will directly gets data from RSS sources.")
        }

        Item { width: 10; height: units.gu(1); } // just a separator

        ListItem.ThinDivider{ }

        ListItem.Standard {
            text: i18n.tr("Use Google Search: ")
            control:
                Switch {
                id: swUseGfa
                anchors.right: parent.right

                onCheckedChanged: {
                    if (preventSave)
                        return
                    optionsKeeper.useGoogleSearch = checked
                }
            }
        }

        ListItem.Divider { }
        /////////////////////////////////////////////////////////////////////   Google RSS engine switch    end here


        /////////////////////////////////////////////////////////////////////   Import OPML functions    start here
        Item { width: 10; height: units.gu(1); } // just a separator

        Label {
            anchors { left: parent.left; right: parent.right; margins: units.gu(2) }
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
            text: i18n.tr("For those users, who want to import their RSS feeds from other sources, please press the button below.")
        }

        Item { width: 10; height: units.gu(1); } // just a separator
        ListItem.ThinDivider{ }
        Item { width: 10; height: units.gu(1); } // just a separator

        Button {
            anchors { left: parent.left; right: parent.right; margins: units.gu(2) }
            anchors.horizontalCenter: parent.horizontalCenter
            text: i18n.tr("Import OMPL")

            onClicked: {
                pageStack.push(Qt.resolvedUrl("../content/ImportFeeds.qml")) ;
            }
        }


        /////////////////////////////////////////////////////////////////////   Import OPML functions    end here

    }// Column

}
