import QtQuick 2.4
import Ubuntu.Components 1.3
import Ubuntu.Components.ListItems 1.3 as ListItem
import Ubuntu.Components.Popups 1.3
import Ubuntu.Layouts 1.0

import "../utils/databasemodule_v2.js" as DB

Page {
    id: topicManagement
    objectName: "topicmanagement"

    title: i18n.tr("Edit topics")
    flickable: content

    signal feedEdit(int topicId)
    signal topicDeleted()

    Component.onCompleted: {
        reloadTopics ()
    }

    function reloadTopics () {
        topicModel.clear()
        var topics = DB.loadTags()
        for (var i = 0; i < topics.rows.length; i++){
            topicModel.append({"id": topics.rows[i].id
                                  ,"name": topics.rows[i].name } )
        }
    }

    function removeModelItem (modelIndex){
        topicModel.remove(modelIndex)
        topicDeleted()
    }

    function reloadPageContent() {
        topicManagement.flickable = null
        topicManagement.flickable = content
    }

    /*
      main content
    */
    Flickable {
        id: content
        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
            bottom: fakePanel.top
        }
        contentHeight: contentItem.childrenRect.height

        /*
          idea from music app, set interactive to false may work
        */
//        state: "normal"
//        states: [
//            State {
//                name: "normal"
//                PropertyChanges {
//                    target: content
//                    interactive: true
//                }
//            },
//            State {
//                name: "reorder"
//                PropertyChanges {
//                    target: content
//                    interactive: false
//                }
//            }
//        ]

        Column{
            anchors{ left: parent.left; right: parent.right }

            /*
              add topic button
            */
            Item {
                id: itemAddTopic
                objectName: "addTopic"
                anchors{ left: parent.left; right: parent.right }
                height: units.gu(9)

                Button {
                    id: btnAddTopic

                    objectName: "btnAddTopic"
                    text: i18n.tr("Add topic")
                    anchors { fill: parent; margins: units.gu(2) }
                    onClicked: pageStack.push(createTopicPage)
                }
            }

            /*
              topic listview
            */
            ListView {
                id: topicList
                anchors{ left: parent.left; right: parent.right }
                height: contentItem.childrenRect.height
                interactive: false
                currentIndex: -1

                property int feedSelectedIndex: -1
                // property alias flickState: content.state

                signal collapseAllItem()

                function collapseAll(){
                    collapseAllItem()
                }

                displaced: Transition {
                    NumberAnimation { properties: "x,y"; easing.type: Easing.OutQuad }
                }

                model: ListModel {
                    id: topicModel
                }

                delegate: MouseArea {
                    id: delegateRoot

                    // property int visualIndex: VisualDataModel.itemsIndex
                    property alias isExpanded: topicItem.isExpanded
                    // property alias isEditing: topicItem.isEditing

                    anchors { left: parent.left; right: parent.right }
                    height: topicItem.height

                    function cancelEdit() {
                        topicItem.cancelEdit()
                    }

                    function confirmEdit() {
                        topicItem.confirmEdit()
                    }

                    TopicComponent {
                        id: topicItem
                        topicName: model.name
                        topicId: model.id
                        modelIndex: index
                        // isSelected: VisualDataModel.itemsIndex == topicList.feedSelectedIndex

                        onEdit: {
                            if (topicList.currentItem)
                                topicList.currentItem.cancelEdit()
                            topicManagement.state = "editMode"
                            topicList.currentIndex = index
                        }

                        onEditCanceled: {
                            if (topicList.currentItem)
                                topicList.currentItem.cancelEdit()
                            topicManagement.state = "default"
                            topicList.currentIndex = -1
                        }

                        onFeedDeleted: {
                            feedEdit(model.id)
                        }

//                        states: [
//                            State {
//                                name: ""
//                                PropertyChanges {
//                                    target: topicItem
//                                    isSelected: false
//                                }
//                            },
//                            State {
//                                name: "selected"
//                                when: delegateRoot.isSelected
//                                PropertyChanges {
//                                    target: topicItem
//                                    isSelected: true
//                                }
//                            }
//                        ]
                    }

                    Connections {
                        id: connTopicList
                        target: topicList

                        onCollapseAllItem: {
                            delegateRoot.isExpanded = false
                        }
                    }

                    Connections {
                        id: connEditFeed0
                        target: editFeed

                        onApply:{
                            if (model.id == newTopicId || model.id == previousTopicId){
                                topicItem.reloadFeed()
                                topicItem.isExpanded = true
                                feedEdit(previousTopicId)
                                feedEdit(newTopicId)
                            }
                        }

                        onDeleteFeed:{
                            if (model.id == topicId){
                                topicItem.reloadFeed()
                                topicItem.isExpanded = true
                                feedEdit(topicId)
                            }
                        }
                    }

                }
            } // listview

        } // column
    } // flickable

    Rectangle {
        id: fakePanel

        color: "#fafafa"
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }
        height: units.gu(6)
        Item {
            anchors.fill: parent

            Button {
                id: cancelButton
                text: i18n.tr("Cancel")
                gradient: UbuntuColors.greyGradient
                anchors {
                    verticalCenter: parent.verticalCenter
                    left: parent.left
                    leftMargin: units.gu(1)
                }
                visible: topicManagement.state == "editMode"
                onClicked: {
                    Qt.inputMethod.hide()
                    topicList.currentItem.cancelEdit()
                    topicManagement.state = "default"
                    topicList.currentIndex = -1
                    timerHeader.start()
                }
            }

            Button {
                id: confirmButton
                text: i18n.tr("Confirm")
                anchors {
                    verticalCenter: parent.verticalCenter
                    right: parent.right
                    rightMargin: units.gu(1)
                }
                visible: topicManagement.state == "editMode"
                onClicked: {
                    topicList.currentItem.confirmEdit()
                    topicManagement.state = "default"
                    topicList.currentIndex = -1
                }
            }

            Button {
                id: actionsButton
                text: i18n.tr("Add Feed")
                anchors {
                    verticalCenter: parent.verticalCenter
                    right: parent.right
                    rightMargin: units.gu(1)
                }
                visible: topicManagement.state != "editMode"
                onClicked: pageStack.push(appendFeedPage/*, {"isDirty" : true}*/)
            }
        }
    } // Rectangle fakePanel


    Timer {
        id: timerHeader
        interval: 500; running: false; repeat: false; triggeredOnStart: false
        onTriggered: topicManagement.header.show()
    }

    Connections{
        id: connAddTopic
        target: createTopicPage

        onTopicAdded:{
            reloadTopics()
        }
    }

    Connections {
        id: connAddFeed
        target: chooseTopicPage

        onTopicChoosen: {
            reloadTopics()
            for (var i = 0; i < topicModel.count; i++){
                if (topicModel.get(i).id == topicId){
                    topicList.currentIndex = i
                    topicList.currentItem.isExpanded = true
                }
            }
        }
    }

    states: [
        State {
            name: "default"
        },
        State {
            name: "editMode"
        }
    ]

}
